function [error, labels] = R_SCORE(A, k,init_label, iter,P, true_label,theta)
    n=size(A,1);
    labels = init_label;
    for i = 1:iter
        % Refit theta and P
        [theta_hat, P_hat] = Refit(A, k, labels);
        Pi_hat = zeros(n, k); 
        for kk = 1:k
             Pi_hat(labels==kk, kk)=1;
        end    
    
        % Calculate and display errors
        P_error = sum(abs(P_hat(:) - P(:)));
        theta_error = sum((theta_hat(:) - theta(:)).^2);
        disp(['P_error: ', num2str(P_error), ', theta_error: ', num2str(theta_error)]);


    
    
        % Compute est_tOmega
        est_tOmega = (Pi_hat * P_hat * Pi_hat') .* (theta_hat * theta_hat');
        
        % Compute est_K_inv and est_Omega
        est_K_inv = 1 + est_tOmega;
        A_hat = est_K_inv .* A;
    
        % SCORE
        
        labels =  SCORE(A_hat, k);
        [error,aligned_labels] = recovery_error(true_label, labels);
        fprintf(' %i th iteration; clustering error: %f\n', i, error)

    
    end
end